statemachine class W3MFireMine extends CGameplayEntity 
{	
	var ent : CEntity;
	var movementAdjustor 														: CMovementAdjustor;
	var ticket 			 														: SMovementAdjustmentRequestTicket;	
	var effectent,effectent1													: CEntity;
	var time 																	: float;
	var dmg_action                                                              : W3DamageAction;
	var damage                                                                  : Float;
	var spellpower 																: SAbilityAttributeValue;
	var victim																	: CNewNPC;	
	var entities 																: array< CGameplayEntity >;
	var randenemy, i 															: int;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		this.AddTimer('firemine_check_targets', 0.1, true);
		this.PlayEffectSingle('yrden_shock_rune');
		this.PlayEffectSingle('yrden_shock_rune1');
	}
	
	event OnDestroyed()
	{
		this.RemoveTimer('deal_damage_firemine');
	}

    timer function firemine_check_targets(deltaTime : float, id : int) 
	{
		entities.Clear();
		FindGameplayEntitiesInRange( entities, this, 1, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		
		if ( entities.Size() > 0 )
		{
			this.RemoveTimer('firemine_check_targets');
			this.AddTimer('deal_damage_firemine', 0.75);
			destroyfiremine();
			
			effectent = (CEntity)theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\mines\marker.w2ent",true),
				this.GetWorldPosition() );
			effectent.PlayEffectSingle('marker_fire');
			//effectent.StopAllEffectsAfter(0.75);
			effectent.DestroyAfter(1);
		}
		
	}
	
	function destroyfiremine()
	{
		StopAllEffects();
		DestroyAfter(2);
	}
	
	timer function deal_damage_firemine( deltaTime : float , id : int)
	{
		
		
		effectent = (CEntity)theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\bob\data\gameplay\abilities\dracolizard\dracolizard_fire_projectile.w2ent",true),
			this.GetWorldPosition() );
		effectent.PlayEffectSingle('venom_hit');
		effectent.DestroyAfter(10);
		
		
		effectent1 = (CEntity)theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\mines\pc_igni_mines.w2ent",true),
			this.GetWorldPosition() );
		effectent1.PlayEffectSingle('igni_blast_360');
		//effectent1.PlayEffectSingle('igni_blast_360_power'); //!!!---
		effectent1.PlayEffectSingle('igni_blast_360_melt');
		effectent1.DestroyAfter(5);
		
		entities.Clear();
		FindGameplayEntitiesInRange( entities, this, 5, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		if( entities.Size()>0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				entities[i].OnIgniHit( NULL );
				
				victim = (CNewNPC)entities[i];
		
				damage = get_damage_value_for_projectile( (CActor)victim, get_spellpower_spells( true ) );
				damage += damage * get_manual_aiming_dmg_mod();	  
				damage -= damage * 0.3;
				
				dmg_action = new W3DamageAction in this;
				dmg_action.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_Heavy,CPS_Undefined,false,false,true,false);	
				dmg_action.SetProcessBuffsIfNoDamage(true);
				if ( !victim.HasBuff( EET_Knockdown ) && !victim.HasBuff( EET_HeavyKnockdown ) && !victim.GetIsRecoveringFromKnockdown() && !victim.HasBuff( EET_Ragdoll ) )
				{
					dmg_action.AddEffectInfo( EET_Knockdown, 4 );
				}
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					dmg_action.SetForceExplosionDismemberment();
				}
				
				dmg_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage );
				theGame.damageMgr.ProcessAction( dmg_action );
				delete dmg_action;
			}
		}
	}
}	




statemachine class W3MElectroMine extends CGameplayEntity 
{	
	var ent : CEntity;
	var movementAdjustor 														: CMovementAdjustor;
	var ticket 			 														: SMovementAdjustmentRequestTicket;	
	var effectent,effectent1																: CEntity;
	var time 																	: float;
	var dmg_action                                                             : W3DamageAction;
	var damage                                                                  : Float;
	var spellpower 																: SAbilityAttributeValue;
	var victim																	: CNewNPC;	
	var entities 																: array< CGameplayEntity >;
	var randenemy, i 															: int;
	var rot 																	: EulerAngles;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		this.AddTimer('firemine_check_targets', 0.1, true);
		this.PlayEffectSingle('yrden_shock_rune');
		this.PlayEffectSingle('yrden_shock_rune1');
	}
	
	event OnDestroyed()
	{
		this.RemoveTimer('deal_damage_firemine');
	}

    timer function firemine_check_targets(deltaTime : float, id : int) 
	{
		entities.Clear();
		FindGameplayEntitiesInRange( entities, this, 1, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		
		if ( entities.Size() > 0 )
		{
			this.RemoveTimer('firemine_check_targets');
			this.AddTimer('deal_damage_firemine', 0.75);
			destroyfiremine();
			
			effectent = (CEntity)theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\mines\marker.w2ent",true),
				this.GetWorldPosition() );
			effectent.PlayEffect('marker_electro1');
			effectent.StopAllEffectsAfter(1);
			effectent.DestroyAfter(2);
		}
		
	}
	
	function destroyfiremine()
	{
		StopAllEffects();
		DestroyAfter(2);
	}
	
	timer function deal_damage_firemine( deltaTime : float , id : int)
	{
		effectent = (CEntity)theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\mines\soceress_arcane_missile.w2ent",true),
			this.GetWorldPosition() );
				effectent.PlayEffect( 'explode' );
		effectent.DestroyAfter(5);
		
		entities.Clear();
		FindGameplayEntitiesInRange( entities, this, 5, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		if( entities.Size()>0 )
		{
		
			for( i = 0; i < entities.Size(); i += 1 )
			{
				victim = (CNewNPC)entities[i];
				
				damage = get_damage_value_for_projectile( (CActor)victim, get_spellpower_spells( true ) );
				damage += damage * get_manual_aiming_dmg_mod();	  
				damage -= damage * 0.3;
				
				dmg_action = new W3DamageAction in this;
				dmg_action.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
				dmg_action.SetProcessBuffsIfNoDamage(true);
				
				//if ( !victim.HasBuff( EET_Knockdown ) && !victim.HasBuff( EET_HeavyKnockdown ) && !victim.GetIsRecoveringFromKnockdown() && !victim.HasBuff( EET_Ragdoll ) )
				//{
					dmg_action.AddEffectInfo( EET_Confusion,4 );
				//}
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					dmg_action.SetForceExplosionDismemberment();
				}
				
				dmg_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage );
				theGame.damageMgr.ProcessAction( dmg_action );
				delete dmg_action;
				
			}
		}
	}
}	


statemachine class W3MFrostMine extends CGameplayEntity 
{	
	var ent : CEntity;
	var movementAdjustor 														: CMovementAdjustor;
	var ticket 			 														: SMovementAdjustmentRequestTicket;	
	var effectent,effectent1  													: CEntity;
	var time 																	: float;
	var dmg_action                           	                                : W3DamageAction;
	var damage                                                                  : Float;
	var spellpower 																: SAbilityAttributeValue;
	var victim																	: CNewNPC;	
	var entities 																: array< CGameplayEntity >;
	var randenemy, i 															: int;
	var pos 																	: Vector;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		this.AddTimer('firemine_check_targets', 0.1, true);
		this.PlayEffectSingle('yrden_shock_rune');
		this.PlayEffect('yrden_slowdown');
		
		if ( !theSound.SoundIsBankLoaded("ep2_mutations_06.bnk") )
		{	
			theSound.SoundLoadBank( "ep2_mutations_06.bnk", false );	
		}
		
		pos = this.GetWorldPosition();
		pos.Z += 0.5;
	}
	
	event OnDestroyed()
	{
		this.RemoveTimer('deal_damage_firemine');
	}

    timer function firemine_check_targets(deltaTime : float, id : int) 
	{
		entities.Clear();
		FindGameplayEntitiesInRange( entities, this, 1, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		
		if ( entities.Size() > 0 )
		{
			this.RemoveTimer('firemine_check_targets');
			this.AddTimer('deal_damage_firemine', 0.75);
			destroyfiremine();
			
			effectent = (CEntity)theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\mines\marker.w2ent",true),
				this.GetWorldPosition() );
			effectent.PlayEffectSingle('marker_frost');
			effectent.StopAllEffectsAfter(1);
			effectent.DestroyAfter(2);
		}
		
	}
	
	function destroyfiremine()
	{
		StopAllEffects();
		DestroyAfter(2);
	}
	
	timer function deal_damage_firemine( deltaTime : float , id : int)
	{
		var pos : Vector;
		
		theGame.GetSurfacePostFX().AddSurfacePostFXGroup(this.GetWorldPosition(), 1, 3, 1,7, 0 );
		
		pos = this.GetWorldPosition();
		pos.Z += 1.5;
		effectent1 = (CEntity)theGame.CreateEntity( (CEntityTemplate) LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\mines\pc_igni_mines.w2ent",true),
			pos );
		effectent1.PlayEffectSingle('frost_mine');
		effectent1.PlayEffectSingle('igni_blast_360_frost_mine');
		effectent1.DestroyAfter(5);
		
		this.SoundEvent('ep2_mutations_06_frosty_aard');
		this.SoundEvent('sign_igni_charge_begin');
		
		entities.Clear();
		FindGameplayEntitiesInRange( entities, this, 5, 100, , FLAG_Attitude_Hostile+FLAG_OnlyAliveActors+FLAG_ExcludePlayer );
		if( entities.Size()>0 )
		{
			for( i = 0; i < entities.Size(); i += 1 )
			{
				if ( !entities[i].HasTag('spells_custom_projs') )
				{
					entities[i].OnAardHit( NULL );
				}
				victim = (CNewNPC)entities[i];
		
				damage = get_damage_value_for_projectile( (CActor)victim, get_spellpower_spells( true ) );
				damage += damage * get_manual_aiming_dmg_mod();	  
				damage -= damage * 0.3;
				
				dmg_action = new W3DamageAction in this;
				dmg_action.Initialize(thePlayer,victim,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
				dmg_action.SetProcessBuffsIfNoDamage(true);
				if( RandF() <= 0.5 )
				{
					dmg_action.AddEffectInfo( EET_Frozen, 4 );
				}
				else
				{
					dmg_action.AddEffectInfo( EET_SlowdownFrost, 5 );
					dmg_action.AddEffectInfo( EET_Stagger );
				}
				
				if ( spells_can_dismember( (CActor)victim ) )
				{
					dmg_action.SetForceExplosionDismemberment();
				}
				
				dmg_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() * damage );
				theGame.damageMgr.ProcessAction( dmg_action );
				delete dmg_action;
			}
		}
	}
}	


class W3SandProj extends W3AdvancedProjectile
{
	protected var collidedEntities2 : array<CGameplayEntity>;
	editable var initFxName 		: name;
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities 					: array< CGameplayEntity >;
	var i,z 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;

	
	event OnProjectileInit()
	{
		isActive = true;
		this.AddTimer('check_targets_sand', 0.01, true );	
		//this.PlayEffect(initFxName);
		collidedEntities2.Clear();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{	
		if ( VecDistance(lastCollisionFxPos, pos) > 1 && isActive )
		{
			lastCollisionFxPos = pos;
			this.PlayEffect('venom_hit');
			//theGame.witcherLog.AddMessage("OnProjectileCollision");
		}
		
		if ( (( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) ) && isActive ) )
		{
			to_destroy();
		}
	}
	
	timer function spells_destroy_sand_proj( deltaTime : float , id : int)
	{
		to_destroy();
	}
	
	function to_destroy()
	{
		this.StopProjectile();
		//theGame.witcherLog.AddMessage("spells_destroy_sand_proj");
		this.DestroyAfter(2);
		isActive = false;
		this.RemoveTimer('check_targets_sand');
	}
	
	timer function check_targets_sand( deltaTime : float , id : int)
	{
		//thePlayer.Teleport( TraceFloor( this.GetWorldPosition() + this.GetWorldForward()*2 ) );
		
		entities.Clear();
		for( z = 0; z <= 3; z += 1 )
		{
			if ( VecDistance( this.GetWorldPosition(), thePlayer.GetWorldPosition() ) >= z * 0.75 )
			{
				FindGameplayEntitiesInSphere( entities, this.GetWorldPosition() - this.GetWorldForward()*z, 0.75, 10 );
				if ( entities.Size() > 0 )
				for( i = 0; i < entities.Size(); i += 1 )
				{
					if ( !collidedEntities2.Contains(entities[i]) && entities[i] != thePlayer && !entities[i].HasTag('spells_custom_projs') && entities[i] != this )
					{
						entities[i].OnAardHit( NULL );
						collidedEntities2.PushBack(entities[i]);
					}
					
					victimsand = (CNewNPC)entities[i];
					
					if ( victimsand && !collidedEntities.Contains(victimsand) && victimsand != thePlayer 
						&& ( GetAttitudeBetween( victimsand, thePlayer ) == AIA_Hostile) && victimsand.IsAlive() )
					{
						DealDamageToVictim( victimsand );
					}
				}
			}
		}
	}
	
	protected function DealDamageToVictim( victimsand : CNewNPC )
	{
		//victimsand.PlayEffect('yrden_shock');
		this.PlayEffect('venom_hit');
		
		dmg_action = new W3DamageAction in this;
		dmg_action.Initialize(thePlayer,victimsand,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
		dmg_action.SetProcessBuffsIfNoDamage(true);
		
		dmg_action.AddEffectInfo( EET_KnockdownTypeApplicator );
			
		damage = get_damage_value_for_projectile( (CActor)victimsand, get_spellpower_spells( true ) );
		damage += damage * get_manual_aiming_dmg_mod();	  
		damage -= damage * 0.1;
		
		if ( spells_can_dismember( (CActor)victimsand ) )
		{
			dmg_action.SetForceExplosionDismemberment();
		}
		dmg_action.AddDamage( theGame.params.DAMAGE_NAME_FORCE, sp_force_dmg_mod() * damage );
		
		theGame.damageMgr.ProcessAction( dmg_action );
		delete dmg_action;
		
		collidedEntities.PushBack(victimsand);
	}
	
	event OnDestroyed()
	{
		//theGame.witcherLog.AddMessage("SAND DESTROYED");
	}
}


class W3SandProjD extends W3AdvancedProjectile
{
	event OnProjectileInit()
	{
		this.PlayEffect( 'venom' );
	}
	event OnDestroyed()
	{
		//theGame.witcherLog.AddMessage("SAND DESTROYED");
	}
}

class W3FireProj extends W3AdvancedProjectile
{
	protected var collidedEntities2 : array<CGameplayEntity>;
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities,entities2,entities3: array< CGameplayEntity >;
	var i	 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var eff							: CEntity;

	event OnProjectileInit()
	{
		this.AddTimer('check_targets_fire', 0.f, true );	
		this.AddTimer('play_fire_effect', 0.01f, true );	
	
		collidedEntities2.Clear();
	
		this.PlayEffect( 'venom1' );
		this.PlayEffect( 'venom3' );
		
		if ( !theSound.SoundIsBankLoaded("monster_dracolizard.bnk") )
		{	
			theSound.SoundLoadBank( "monster_dracolizard.bnk", false );	
		}
		
		this.SoundEvent("monster_dracolizard_combat_fire_spit");
	}
	
	timer function play_fire_effect( deltaTime : float , id : int)
	{
		this.PlayEffect( 'venom' );
		this.PlayEffect( 'venom3' );
	}
	
	timer function spells_destroy_fire_proj( deltaTime : float , id : int)
	{
		to_destroy();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		theGame.GetSurfacePostFX().AddSurfacePostFXGroup(pos, 0.3f, 5, 1.f, 3.f, 1);
	
		if ( ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Static' ) || hitCollisionsGroups.Contains( 'Water' ) ) )
		{
			to_destroy();
		}
	}
	
	function to_destroy()
	{
		this.StopProjectile();
		this.RemoveTimer('play_fire_effect');
		this.RemoveTimer('spells_destroy_fire_proj');
		this.StopAllEffects();
		this.DestroyAfter(5);
		this.RemoveTimer('check_targets_fire');
	}
	
	event OnDestroyed()
	{
	}
	
	timer function check_targets_fire( deltaTime : float , id : int)
	{
		entities.Clear();
		FindGameplayEntitiesInSphere( entities, this.GetWorldPosition()+this.GetWorldForward()*2, 0.7, 10 );
		FindGameplayEntitiesInSphere( entities2, this.GetWorldPosition()+this.GetWorldForward(), 0.7, 10 );
		FindGameplayEntitiesInSphere( entities3, this.GetWorldPosition()-this.GetWorldForward(), 0.7, 10 );
		
		for( i = 0; i < entities2.Size(); i += 1 )
		{
			entities.PushBack(entities2[i]);
		}
		
		for( i = 0; i < entities3.Size(); i += 1 )
		{
			entities.PushBack(entities3[i]);
		}
		
		if ( entities.Size() > 0 )
		for( i = 0; i < entities.Size(); i += 1 )
		{
			if ( !collidedEntities2.Contains(entities[i]) && entities[i] != thePlayer && !entities[i].HasTag('sandprojdummy') && entities[i] != this )
			{
				entities[i].OnIgniHit( NULL );
				collidedEntities2.PushBack(entities[i]);
			}
			
			victimsand = (CNewNPC)entities[i];
			
			if ( victimsand && !collidedEntities.Contains(victimsand) && victimsand != thePlayer 
				&& ( GetAttitudeBetween( victimsand, thePlayer ) == AIA_Hostile) && victimsand.IsAlive() )
			{
				DealDamageToVictim( victimsand );
			}
		}
	}
	
	protected function DealDamageToVictim( victimsand : CNewNPC )
	{
		dmg_action = new W3DamageAction in this;
		dmg_action.Initialize(thePlayer,victimsand,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
		dmg_action.SetProcessBuffsIfNoDamage(true);
		
		if( RandF() <= 0.4 )
		{
			dmg_action.AddEffectInfo( EET_Burning, 1 );
		}
		
		dmg_action.SetHitEffect('igni_cone_hit', false, false);
		dmg_action.SetHitEffect('igni_cone_hit', true, false);
		dmg_action.SetHitReactionType(EHRT_Igni, false);
		
		damage = get_damage_value_for_projectile( (CActor)victimsand, get_spellpower_spells( true ) );
		damage += damage * get_manual_aiming_dmg_mod();	  
		
		if ( spells_can_dismember( (CActor)victimsand ) )
		{
			dmg_action.SetForceExplosionDismemberment();
		}
		
		dmg_action.AddDamage( theGame.params.DAMAGE_NAME_FIRE, sp_fire_dmg_mod() * damage );
		
		theGame.damageMgr.ProcessAction( dmg_action );
		delete dmg_action;
		
		eff = victimsand.CreateFXEntityAtPelvis( 'fire_gnosis_effects', true );
		eff.PlayEffect( 'flame' );
		eff.DestroyAfter(5);
		
		collidedEntities.PushBack(victimsand);
	}
}

class W3FireProjD extends W3AdvancedProjectile
{
	event OnProjectileInit()
	{
		this.PlayEffect( 'venom' );
		this.PlayEffect( 'venom1' );
		this.StopEffect( 'venom' );
		this.StopEffect( 'venom1' );
		//this.PlayEffect( 'venom2' );
	}
	
	event OnDestroyed()
	{
		//theGame.witcherLog.AddMessage("FIRE DUMMY DESTROYED");
	}
}

class W3ElectroProj extends W3AdvancedProjectile
{
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities,entities2,entities3: array< CGameplayEntity >;
	var i	 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var eff							: CEntity;

	event OnProjectileInit()
	{
		this.PlayEffect( 'venom' );
		this.PlayEffect( 'venom1' );
		
		if ( !theSound.SoundIsBankLoaded("magic_sorceress.bnk") )
		{	
			theSound.SoundLoadBank( "magic_sorceress.bnk", false );	
		}
		if ( !theSound.SoundIsBankLoaded("monster_cloud_giant.bnk") )
		{	
			theSound.SoundLoadBank( "monster_cloud_giant.bnk", false );	
		}
		
		this.SoundEvent("monster_cloud_giant_fx_lightning_begin");
		thePlayer.SoundEvent("sign_yrden_shock_activate");
		this.AddTimer('check_targets_electro', 0.01f, true );	
		this.SoundEvent("magic_sorceress_vfx_lightning_bolt");
		this.SoundEvent("magic_sorceress_vfx_lightning_bolt");
		//this.SoundEvent("amb_dyn_bob_electric_cage_fx_start");
		//this.SoundEvent("amb_dyn_bob_electric_cage_fx_start");
		//thePlayer.SoundEvent("magic_sorceress_vfx_lightning_bolt");
		//thePlayer.SoundEvent("magic_sorceress_vfx_lightning_bolt");
	}
	
	event OnDestroyed()
	{
		//theGame.witcherLog.AddMessage("ELECTRO DUMMY DESTROYED");
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
	
		if ( ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Water' ) ) )
		{
			to_destroy();
		}
	}
	
	timer function spells_destroy_electro_proj( deltaTime : float , id : int)
	{
		to_destroy();
	}
	
	function to_destroy()
	{
		this.SoundEvent("monster_cloud_giant_fx_lightning_end");
		this.StopProjectile();
		this.StopAllEffects();
		this.DestroyAfter(2);
		this.RemoveTimer('spells_destroy_electro_proj');
		this.RemoveTimer('check_targets_electro');
	}
	
	timer function check_targets_electro( deltaTime : float , id : int)
	{
		entities.Clear();
		FindGameplayEntitiesInSphere( entities, this.GetWorldPosition(), 1.5, 10 );
		
		if ( entities.Size() > 0 )
		for( i = 0; i < entities.Size(); i += 1 )
		{
			victimsand = (CNewNPC)entities[i];
			
			if ( victimsand && !collidedEntities.Contains(victimsand) && victimsand != thePlayer 
				&& ( GetAttitudeBetween( victimsand, thePlayer ) == AIA_Hostile) && victimsand.IsAlive() )
			{
				eff = victimsand.CreateFXEntityAtPelvis( 'explosions', true );
				eff.PlayEffect( 'old_gods_hit' );
				eff.DestroyAfter(5);
			
				dmg_action = new W3DamageAction in this;
				dmg_action.Initialize(thePlayer,victimsand,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
				dmg_action.SetProcessBuffsIfNoDamage(true);
				
				dmg_action.SetHitReactionType(EHRT_Igni, false);
				
				dmg_action.SetHitEffect('');
				dmg_action.SetHitEffect('', true );
				dmg_action.SetHitEffect('', false, true);
				dmg_action.SetHitEffect('', true, true);
				
				damage = get_damage_value_for_projectile( (CActor)victimsand, get_spellpower_spells( true ) );
				damage += damage * get_manual_aiming_dmg_mod();	
				damage -= damage * 0.15;
				
				if ( spells_can_dismember( (CActor)victimsand ) )
				{
					dmg_action.SetForceExplosionDismemberment();
				}
				
				dmg_action.AddDamage( theGame.params.DAMAGE_NAME_SHOCK, sp_shock_dmg_mod() * damage );
				
				theGame.damageMgr.ProcessAction( dmg_action );
				delete dmg_action;
				
				collidedEntities.PushBack(victimsand);
			}
		}
	}
}

class W3MFrostProj extends W3AdvancedProjectile
{
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities,entities2,entities3: array< CGameplayEntity >;
	var i	 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var eff							: CEntity;
	var posttest,posttest2 : Vector;
	
	event OnProjectileInit()
	{
		this.PlayEffect( 'venom' );
		this.PlayEffect( 'venom1' );
		this.PlayEffect( 'venom2' );
		
		this.AddTimer('frost_play_effects', 0.4, true);
		this.AddTimer('check_targets_frost', 0.01f, true );	

		if ( !theSound.SoundIsBankLoaded("ep2_mutations_06.bnk") )
		{	
			theSound.SoundLoadBank( "ep2_mutations_06.bnk", false );	
		}
		
		this.SoundEvent('ep2_mutations_06_frosty_aard');
		this.SoundEvent('sign_igni_charge_begin');
	}
	
	timer function check_targets_frost( deltaTime : float , id : int)
	{
		if ( VecDistance( lastCollisionFxPos, GetWorldPosition() ) > 0.6 )
		{
			lastCollisionFxPos = GetWorldPosition();
			theGame.GetSurfacePostFX().AddSurfacePostFXGroup( GetWorldPosition(), 0.3f, 5, 1.f, 7.f, 0);
		}
	
		entities.Clear();
		FindGameplayEntitiesInSphere( entities, this.GetWorldPosition(), 1.5, 10 );
		
		if ( entities.Size() > 0 )
		for( i = 0; i < entities.Size(); i += 1 )
		{
			if ( !entities[i].HasTag('spells_custom_projs') )
			{
				entities[i].OnAardHit( NULL );
			}
		
			victimsand = (CNewNPC)entities[i];
			
			if ( victimsand && !collidedEntities.Contains(victimsand) && victimsand != thePlayer 
				&& ( GetAttitudeBetween( victimsand, thePlayer ) == AIA_Hostile) && victimsand.IsAlive() )
			{
			
				dmg_action = new W3DamageAction in this;
				dmg_action.Initialize(thePlayer,victimsand,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
				dmg_action.SetProcessBuffsIfNoDamage(true);
				
				dmg_action.SetHitReactionType(EHRT_Igni, false);
				
				dmg_action.SetHitEffect('');
				dmg_action.SetHitEffect('', true );
				dmg_action.SetHitEffect('', false, true);
				dmg_action.SetHitEffect('', true, true);
				
				damage = get_damage_value_for_projectile( (CActor)victimsand, get_spellpower_spells( true ) );
				damage += damage * get_manual_aiming_dmg_mod();	  
				damage -= damage * 0.15;
				
				if( RandF() <= 0.5 )
				{
					dmg_action.AddEffectInfo( EET_Frozen, 2 );
				}
				else
				{
					dmg_action.AddEffectInfo( EET_SlowdownFrost, 4 );
				}
				
				eff = victimsand.CreateFXEntityAtPelvis( 'permafrost_effects', true );
				eff.PlayEffect( 'flame_from_cone' );
				eff.DestroyAfter(5);
				
				if ( spells_can_dismember( (CActor)victimsand ) )
				{
					dmg_action.SetForceExplosionDismemberment();
				}
				
				dmg_action.AddDamage( theGame.params.DAMAGE_NAME_FROST, sp_frost_dmg_mod() *  damage );
				
				theGame.damageMgr.ProcessAction( dmg_action );
				delete dmg_action;
				
				collidedEntities.PushBack(victimsand);
			}
		}
	}
	
	
	timer function frost_play_effects( deltaTime : float , id : int)
	{
		this.PlayEffect( 'venom2' );
	}
	
	timer function spells_destroy_frost_proj( deltaTime : float , id : int)
	{
		to_destroy();
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		if ( ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Static' ) || hitCollisionsGroups.Contains( 'Water' ) ) )
		{
			to_destroy();
		}
	}
	
	function to_destroy()
	{
		this.StopProjectile();
		this.RemoveTimer('check_targets_frost');
		this.RemoveTimer('spells_destroy_frost_proj');
		this.RemoveTimer('frost_play_effects');
		this.StopAllEffects();
		this.DestroyAfter(5);
	}
	
	event OnDestroyed()
	{
		//theGame.witcherLog.AddMessage("FIRE DUMMY DESTROYED");
	}
}

class W3BoltSpells extends W3AdvancedProjectile
{
	var boneName 					: name;
	var actorVictim					: CActor;
	var dmg_action                  : W3DamageAction;
	var victimsand					: CNewNPC;	
	var entities 					: array< CGameplayEntity >;
	var i,z 						: int;
	var lastCollisionFxPos 			: Vector;
	var spellpower 					: SAbilityAttributeValue;
	var damage						: Float;
	var ent 						: CEntity;
	
	event OnProjectileInit()
	{
		if ( !theSound.SoundIsBankLoaded("ep2_mutations_09.bnk") )
		{	
			theSound.SoundLoadBank( "ep2_mutations_09.bnk", false );	
		}
	
		//PlayEffect('bolt_spell_trail2'); 
		//PlayEffect('bolt_spell_trail3');
		this.AddTimer('destroy_effect_bolt_spells', 0.2);
	
		PlayEffect('bolt_spell_trail21');
		PlayEffect('bolt_spell_trail31');
		
		this.StopAllEffectsAfter(3);
		this.DestroyAfter(4);
	}
	
	timer function destroy_effect_bolt_spells( deltaTime : float , id : int)
	{
		DestroyEffect('bolt_spell_trail2');
		DestroyEffect('bolt_spell_trail3');
	}
	
	event OnDestroyed()
	{
		//theGame.witcherLog.AddMessage("W3BoltSpells_destroy");
	}
	
	event OnProjectileCollision( pos, normal : Vector, collidingComponent : CComponent, hitCollisionsGroups : array< name >, actorIndex : int, shapeIndex : int )
	{
		var meshComponent		: CMeshComponent;
		var arrowHitPos			: Vector;
		var arrowSize			: Vector;
		var boundingBox			: Box;
	
		if ( hitCollisionsGroups.Contains( 'Terrain' ) || hitCollisionsGroups.Contains( 'Static' ) )
		{
			StopAllEffects();
			this.SoundEvent("cmb_arrow_impact_dirt");
			
			if ( VecDistance ( thePlayer.GetWorldPosition(), pos ) > 7 )
			{
				StopProjectile();
				this.DestroyAfter(5);
				
				arrowHitPos = pos;
				meshComponent = (CMeshComponent)GetComponentByClassName('CMeshComponent');
				if( meshComponent )
				{
					boundingBox = meshComponent.GetBoundingBox();
					arrowSize = boundingBox.Max - boundingBox.Min;
					arrowHitPos -= RotForward(  this.GetWorldRotation() ) * arrowSize.X * 0.7f; 
				}
				
				Teleport( arrowHitPos );
			}
			else
			{
				this.DestroyAfter(1);
			}
			
		}
		
		if(collidingComponent)
			victim = (CGameplayEntity)collidingComponent.GetEntity();
		
		if( collidingComponent )
		{	
			//if ( !victim || collidedEntities.Contains(victim) || victim == caster )
			//	return false;
			
			actorVictim = (CActor)victim;
			
			if ( hitCollisionsGroups.Contains( 'Ragdoll' ) && actorVictim )
			{
				boneName = ((CMovingPhysicalAgentComponent)actorVictim.GetMovingAgentComponent()).GetRagdollBoneName(actorIndex);
			}
			
			if ( victim && !collidedEntities.Contains(victim) && victim != thePlayer && ( GetAttitudeBetween( victim, thePlayer ) == AIA_Hostile) && victim.IsAlive())
			{
				victimsand = (CNewNPC)victim;
			
				dmg_action = new W3DamageAction in this;
				dmg_action.Initialize(thePlayer,victimsand,this,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
				dmg_action.SetProcessBuffsIfNoDamage(true);
				
				if ( boneName == 'head' || boneName == 'neck' || boneName == 'hroll' || ( boneName == 'pelvis' && victimsand.IsHuman() ) )
					dmg_action.SetHeadShot();
				
				spellpower = GetWitcherPlayer().GetTotalSignSpellPower(S_Magic_1);
				damage = thePlayer.GetLevel()*5;
				damage += damage * ( ( get_spellpower_spells( true ) ) * get_spellpower_mult() );
				
				if(	!victimsand.IsHuman() && !victimsand.IsAnimal()	)
				{	
					damage += damage * get_monsters_mult();	  
				}
				
				damage += damage * get_manual_aiming_dmg_mod();	  
				damage += damage * get_overall_mult();
				
				if ( theGame.GetInGameConfigWrapper().GetVarValue('magic_spells', 'spells_rand_dmg') )
				{
					damage *= RandRangeF(1.1, 0.9);
				}
				
				if( RandF() <= 0.25 )
				{
					if( RandF() > 0.5 )
					{
						dmg_action.AddEffectInfo( EET_Poison,   ( get_spellpower_spells( true )+1 ) *2 );
					}
					else
					{
						dmg_action.AddEffectInfo( EET_Bleeding, ( get_spellpower_spells( true )+1 ) *2 );
					}
				}
				
				if ( spells_can_dismember( ((CActor) victimsand) ) )
				{
					dmg_action.SetForceExplosionDismemberment();
				}
				
				dmg_action.AddDamage( theGame.params.DAMAGE_NAME_DIRECT, sp_direct_dmg_mod() * damage );
				
				if ( !victimsand.HasBuff( EET_Stagger ) )
				{
					dmg_action.AddEffectInfo( EET_Stagger );
				}
				
				
				theGame.damageMgr.ProcessAction( dmg_action );
				delete dmg_action;
				
				ent = theGame.CreateEntity( (CEntityTemplate)LoadResource( 'manaim_effects' ), pos  );
				ent.PlayEffect( 'assassin_bolt_hit' );
				ent.SoundEvent( 'ep2_mutations_09_bolt_impact_armor_type' );
				
				collidedEntities.PushBack(victim);
			}
		}
	}
}


class W3VampShed extends CGameplayEntity
{
	var i,z,zz						: Int;
	var dummies 					: array< CEntity >;
	var ent,ent1 					: CEntity;
	var actors  					: array<CActor>;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		if ( !theSound.SoundIsBankLoaded("sign_yrden.bnk") )
		{	
			theSound.SoundLoadBank( "sign_yrden.bnk", false );	
		}
		
		this.SoundEvent( 'sign_yrden_paralysis_loop' );
	
		PlayEffect('marker_vamp');
		PlayEffect('marker_vamp2');
		
		this.AddTimer('check_vamp_pillars', 0.1, true );	
	}
	
	timer function check_vamp_pillars( deltaTime : float , id : int)
	{
		if ( theGame.GetEntityByTag( 'vamp_shed_pillar_2' ) )
		{
			this.RemoveTimer('check_vamp_pillars');
			
			build_vamp_fence( this, 'vamp_shed_pillar_2', 'vampire_pillar_fence_small_1' );
			
			actors.Clear();
			this.AddTimer('vamp_fence_check_targets',0.01, true);
			this.AddTimer('vamp_fence_clear_targets',2, true);
		}
	}
	
	timer function vamp_fence_check_targets( deltaTime : float , id : int)
	{
		var results 													: array<SRaycastHitResult>;
		var entity, effect 												: CEntity;
		var targetActor 												: CActor;
		var dmg_action 													: W3DamageAction;
		
		dummies.Clear();
		theGame.GetEntitiesByTag('vampire_pillar_fence_small_1',dummies);
		for(z=1; z < dummies.Size(); z+=1)
		{
			ent = dummies[z-1];
			ent1 = dummies[z];
			
			results.Clear();
			FindActorsAtLine( ent.GetWorldPosition(), ent1.GetWorldPosition(), 0.3f, results );
			
			if ( results.Size() > 0 )
			{
				for( zz=0; zz < results.Size(); zz+=1)
				{
					if(results[zz].component)
					{
						entity = results[zz].component.GetEntity();
						targetActor = (CActor)entity;
							
						if(targetActor && IsRequiredAttitudeBetween(targetActor, thePlayer, true, false, false) 
							&& targetActor.GetHealth() > 0.f && targetActor.IsAlive() && !actors.Contains(targetActor) )
						{
							vamp_fence_proc(this,targetActor);
							actors.PushBack(targetActor);
							ent1.SoundEvent( 'sign_axii_release' );
						}
					} 	
				}
			}
		}
	}
	
	timer function vamp_fence_clear_targets( deltaTime : float , id : int)
	{
		actors.Clear();
	}
	
	
	timer function destroy_vamp_pillar_fence( deltaTime : float , id : int)
	{
		this.StopAllEffects();
		this.AddTimer('destroy_vamp_pillar_fence2',1);
	}
	
	timer function destroy_vamp_pillar_fence2( deltaTime : float , id : int)
	{
		this.Destroy();
	}
	
	event OnDestroyed()
	{
		RemoveTimer('check_vamp_pillars');
		RemoveTimer('vamp_fence_check_targets');
		RemoveTimer('vamp_fence_clear_targets');
		this.SoundEvent( 'sign_yrden_paralysis_loop_END' );
	}
}


class W3VampShed2 extends CGameplayEntity
{
	var i,z,zz						: Int;
	var dummies 					: array< CEntity >;
	var ent,ent1 					: CEntity;
	var actors  					: array<CActor>;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		if ( !theSound.SoundIsBankLoaded("sign_yrden.bnk") )
		{	
			theSound.SoundLoadBank( "sign_yrden.bnk", false );	
		}
		
		this.SoundEvent( 'sign_yrden_paralysis_loop' );
	
		PlayEffect('marker_vamp');
		PlayEffect('marker_vamp2');
		
		this.AddTimer('check_vamp_pillars', 0.1, true );	
	}
	
	timer function check_vamp_pillars( deltaTime : float , id : int)
	{
		if ( theGame.GetEntityByTag( 'vamp_shed_pillar_3' ) )
		{
			this.RemoveTimer('check_vamp_pillars');
			
			build_vamp_fence( this, 'vamp_shed_pillar_3', 'vampire_pillar_fence_small_2' );
			
			actors.Clear();
			this.AddTimer('vamp_fence_check_targets',0.01, true);
			this.AddTimer('vamp_fence_clear_targets',2, true);
		}
	}
	
	timer function vamp_fence_check_targets( deltaTime : float , id : int)
	{
		var results 													: array<SRaycastHitResult>;
		var entity, effect 												: CEntity;
		var targetActor 												: CActor;
		var dmg_action 													: W3DamageAction;
		
		dummies.Clear();
		theGame.GetEntitiesByTag('vampire_pillar_fence_small_2',dummies);
		for(z=1; z < dummies.Size(); z+=1)
		{
			ent = dummies[z-1];
			ent1 = dummies[z];
			
			results.Clear();
			FindActorsAtLine( ent.GetWorldPosition(), ent1.GetWorldPosition(), 0.3f, results );
			
			if ( results.Size() > 0 )
			{
				for( zz=0; zz < results.Size(); zz+=1)
				{
					if(results[zz].component)
					{
						entity = results[zz].component.GetEntity();
						targetActor = (CActor)entity;
							
						if(targetActor && IsRequiredAttitudeBetween(targetActor, thePlayer, true, false, false) 
							&& targetActor.GetHealth() > 0.f && targetActor.IsAlive() && !actors.Contains(targetActor) )
						{
							vamp_fence_proc(this,targetActor);
							actors.PushBack(targetActor);
							ent1.SoundEvent( 'sign_axii_release' );
						}
					} 	
				}
			}
		}
	}
	
	timer function vamp_fence_clear_targets( deltaTime : float , id : int)
	{
		actors.Clear();
	}
	
	
	timer function destroy_vamp_pillar_fence( deltaTime : float , id : int)
	{
		this.StopAllEffects();
		this.AddTimer('destroy_vamp_pillar_fence2',1);
	}
	
	timer function destroy_vamp_pillar_fence2( deltaTime : float , id : int)
	{
		this.Destroy();
	}
	
	event OnDestroyed()
	{
		RemoveTimer('check_vamp_pillars');
		RemoveTimer('vamp_fence_check_targets');
		RemoveTimer('vamp_fence_clear_targets');
		this.SoundEvent( 'sign_yrden_paralysis_loop_END' );
	}
}

class W3VampShed3 extends CGameplayEntity
{
	var i,z,zz						: Int;
	var dummies 					: array< CEntity >;
	var ent,ent1 					: CEntity;
	var actors  					: array<CActor>;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		if ( !theSound.SoundIsBankLoaded("sign_yrden.bnk") )
		{	
			theSound.SoundLoadBank( "sign_yrden.bnk", false );	
		}
		this.SoundEvent( 'sign_yrden_paralysis_loop' );
	
		PlayEffect('marker_vamp');
		PlayEffect('marker_vamp2');
		
		this.AddTimer('check_vamp_pillars', 0.1, true );	
	}
	
	timer function check_vamp_pillars( deltaTime : float , id : int)
	{
		if ( theGame.GetEntityByTag( 'vamp_shed_pillar_4' ) )
		{
			this.RemoveTimer('check_vamp_pillars');
			
			build_vamp_fence( this, 'vamp_shed_pillar_4', 'vampire_pillar_fence_small_3' );
			
			actors.Clear();
			this.AddTimer('vamp_fence_check_targets',0.01, true);
			this.AddTimer('vamp_fence_clear_targets',2, true);
		}
	}
	
	timer function vamp_fence_check_targets( deltaTime : float , id : int)
	{
		var results 													: array<SRaycastHitResult>;
		var entity, effect 												: CEntity;
		var targetActor 												: CActor;
		var dmg_action 													: W3DamageAction;
		
		dummies.Clear();
		theGame.GetEntitiesByTag('vampire_pillar_fence_small_3',dummies);
		for(z=1; z < dummies.Size(); z+=1)
		{
			ent = dummies[z-1];
			ent1 = dummies[z];
			
			results.Clear();
			FindActorsAtLine( ent.GetWorldPosition(), ent1.GetWorldPosition(), 0.3f, results );
			
			if ( results.Size() > 0 )
			{
				for( zz=0; zz < results.Size(); zz+=1)
				{
					if(results[zz].component)
					{
						entity = results[zz].component.GetEntity();
						targetActor = (CActor)entity;
							
						if(targetActor && IsRequiredAttitudeBetween(targetActor, thePlayer, true, false, false) 
							&& targetActor.GetHealth() > 0.f && targetActor.IsAlive() && !actors.Contains(targetActor) )
						{
							vamp_fence_proc(this,targetActor);
							actors.PushBack(targetActor);
							ent1.SoundEvent( 'sign_axii_release' );
						}
					} 	
				}
			}
		}
	}
	
	timer function vamp_fence_clear_targets( deltaTime : float , id : int)
	{
		actors.Clear();
	}
	
	
	timer function destroy_vamp_pillar_fence( deltaTime : float , id : int)
	{
		this.StopAllEffects();
		this.AddTimer('destroy_vamp_pillar_fence2',1);
	}
	
	timer function destroy_vamp_pillar_fence2( deltaTime : float , id : int)
	{
		this.Destroy();
	}
	
	event OnDestroyed()
	{
		RemoveTimer('check_vamp_pillars');
		RemoveTimer('vamp_fence_check_targets');
		RemoveTimer('vamp_fence_clear_targets');
		this.SoundEvent( 'sign_yrden_paralysis_loop_END' );
	}
}

class W3VampShed4 extends CGameplayEntity
{
	var i,z,zz						: Int;
	var dummies 					: array< CEntity >;
	var ent,ent1 					: CEntity;
	var actors  					: array<CActor>;
	
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		if ( !theSound.SoundIsBankLoaded("sign_yrden.bnk") )
		{	
			theSound.SoundLoadBank( "sign_yrden.bnk", false );	
		}
		this.SoundEvent( 'sign_yrden_paralysis_loop' );
	
		PlayEffect('marker_vamp');
		PlayEffect('marker_vamp2');
		
		this.AddTimer('check_vamp_pillars', 0.1, true );	
	}
	
	timer function check_vamp_pillars( deltaTime : float , id : int)
	{
		if ( theGame.GetEntityByTag( 'vamp_shed_pillar_1' ) )
		{
			this.RemoveTimer('check_vamp_pillars');
			
			build_vamp_fence( this, 'vamp_shed_pillar_1', 'vampire_pillar_fence_small_4' );
			
			actors.Clear();
			this.AddTimer('vamp_fence_check_targets',0.01, true);
			this.AddTimer('vamp_fence_clear_targets',2, true);
		}
	}
	
	timer function vamp_fence_check_targets( deltaTime : float , id : int)
	{
		var results 													: array<SRaycastHitResult>;
		var entity, effect 												: CEntity;
		var targetActor 												: CActor;
		var dmg_action 													: W3DamageAction;
		
		dummies.Clear();
		theGame.GetEntitiesByTag('vampire_pillar_fence_small_4',dummies);
		for(z=1; z < dummies.Size(); z+=1)
		{
			ent = dummies[z-1];
			ent1 = dummies[z];
			
			results.Clear();
			FindActorsAtLine( ent.GetWorldPosition(), ent1.GetWorldPosition(), 0.3f, results );
			
			if ( results.Size() > 0 )
			{
				for( zz=0; zz < results.Size(); zz+=1)
				{
					if(results[zz].component)
					{
						entity = results[zz].component.GetEntity();
						targetActor = (CActor)entity;
							
						if(targetActor && IsRequiredAttitudeBetween(targetActor, thePlayer, true, false, false) 
							&& targetActor.GetHealth() > 0.f && targetActor.IsAlive() && !actors.Contains(targetActor) )
						{
							vamp_fence_proc(this,targetActor);
							actors.PushBack(targetActor);
							ent1.SoundEvent( 'sign_axii_release' );
						}
					} 	
				}
			}
		}
	}
	
	timer function vamp_fence_clear_targets( deltaTime : float , id : int)
	{
		actors.Clear();
	}
	
	
	timer function destroy_vamp_pillar_fence( deltaTime : float , id : int)
	{
		this.StopAllEffects();
		this.AddTimer('destroy_vamp_pillar_fence2',1);
	}
	
	timer function destroy_vamp_pillar_fence2( deltaTime : float , id : int)
	{
		this.Destroy();
	}
	
	event OnDestroyed()
	{
		RemoveTimer('check_vamp_pillars');
		RemoveTimer('vamp_fence_check_targets');
		RemoveTimer('vamp_fence_clear_targets');
		this.SoundEvent( 'sign_yrden_paralysis_loop_END' );
	}
}

function vamp_fence_proc( gameplayEnt: CGameplayEntity, targetActor : CActor )
{
	var effect 												: CEntity;
	var dmg_action 											: W3DamageAction;
	
	dmg_action = new W3DamageAction in NULL;
	dmg_action.Initialize(gameplayEnt,targetActor,NULL,thePlayer.GetName()+"_sign",EHRT_None,CPS_Undefined,false,false,true,false);	
	dmg_action.SetProcessBuffsIfNoDamage(true);
	
	dmg_action.SetHitEffect('');
	dmg_action.SetHitEffect('', true );
	dmg_action.SetHitEffect('', false, true);
	dmg_action.SetHitEffect('', true, true);
	
	//targetActor.PlayEffect('yrden_shock');
	
	effect = targetActor.CreateFXEntityAtPelvis( 'mutation_1_hit_vampherd', false );
	effect.PlayEffect( 'mutation_1_hit_aard' );
	effect.DestroyAfter(2);
	
	dmg_action.SetForceExplosionDismemberment();
	//dmg_action.AddEffectInfo(EET_Stagger);
	dmg_action.AddEffectInfo(EET_Blindness,7);
	
	theGame.damageMgr.ProcessAction( dmg_action );
	delete dmg_action;
	
	targetActor.Teleport( TraceFloor( targetActor.GetWorldPosition() - targetActor.GetHeadingVector() ) );
}


class W3VampFence extends CGameplayEntity
{
	event OnSpawned( spawnData : SEntitySpawnData )
	{
		if ( !theSound.SoundIsBankLoaded("sign_axii.bnk") )
		{	
			theSound.SoundLoadBank( "sign_axii.bnk", false );	
		}
	}
	
	timer function destroy_vamp_pillar_fence( deltaTime : float , id : int)
	{
		this.StopAllEffects();
		this.AddTimer('destroy_vamp_pillar_fence2',1);
	}
	
	timer function destroy_vamp_pillar_fence2( deltaTime : float , id : int)
	{
		this.Destroy();
	}
}


function reapply_fence_effects()
{
	var dummies 					: array< CEntity >;
	var ent,ent1 					: CEntity;
	var z							: Int;
	
	dummies.Clear();
	theGame.GetEntitiesByTag('vampire_pillar_fence_smalls',dummies);
	for(z=0; z < dummies.Size(); z+=1)
	{
		ent = dummies[z-1];
		ent1 = dummies[z];
		ent.StopEffect( 'marker_vamp4' );
		ent.PlayEffect( 'marker_vamp4', ent1 );
		
		ent.StopEffect( 'marker_vamp2' );
		ent.PlayEffect( 'marker_vamp2' );
	} 	
	
	dummies.Clear();
	theGame.GetEntitiesByTag('vamp_shed_pillars',dummies);
	for(z=0; z < dummies.Size(); z+=1)
	{
		ent = dummies[z];
		ent.StopEffect( 'marker_vamp' );
		ent.StopEffect( 'marker_vamp2' );
		ent.PlayEffect( 'marker_vamp' );
		ent.PlayEffect( 'marker_vamp2' );
	}
	
	dummies.Clear();
	theGame.GetEntitiesByTag('vampire_pillar_fence',dummies);
	for(z=0; z < dummies.Size(); z+=1)
	{
		ent = dummies[z];
		ent.RemoveTimer('destroy_vamp_pillar_fence');
		ent.RemoveTimer('destroy_vamp_pillar_fence2');
		ent.AddTimer('destroy_vamp_pillar_fence',29);
	} 	
}

function build_vamp_fence( start : CEntity, nam : name, nam2 : name )
{
	var stepN 					: Int;
	var dist 					: Float;
	var i,stepLength 			: Float;
	var pos 					: Vector;
	var pillar 					: CEntity;
	var pillar_fence 			: CEntity;

	pillar = theGame.GetEntityByTag( nam );
	
	dist = VecDistance( start.GetWorldPosition(), pillar.GetWorldPosition() );
	if ( dist == 0 ) { dist = 0.1; }
	stepN = RoundMath(dist / 2);
	stepLength = dist / stepN;
	
	for( i = 0; i <= dist; i += stepLength )
	{
		pos = start.GetWorldPosition() - VecFromHeading( AngleNormalize180( pillar.GetHeading()
									  - NodeToNodeAngleDistance( start, pillar)))
									  * i ;
		pos = TraceFloor(pos);
		pos.Z += 0.5;
											  
		pillar_fence = (W3VampFence)theGame.CreateEntity
		( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\vampyr\vamp_shed_fence.w2ent",true ), pos );		
		pillar_fence.AddTag('vampire_pillar_fence');
		pillar_fence.AddTag('vampire_pillar_fence_smalls');
		pillar_fence.AddTag( nam2 );
	}
	
	pillar_fence = (W3VampFence)theGame.CreateEntity
	( (CEntityTemplate)LoadResource( "dlc\magicspellsrev\data\entities\manual_aiming\vampyr\vamp_shed_fence.w2ent",true ), pillar.GetWorldPosition() );		
	pillar_fence.AddTag('vampire_pillar_fence');
	pillar_fence.AddTag('vampire_pillar_fence_smalls');
	pillar_fence.AddTag( nam2 );
	
	reapply_fence_effects();
			
}

/*

fx\characters\djin\before_explode.w2p	light rays
fx\characters\djin\djin_electricity_sphere.w2p 
fx\characters\djin\djin_fx_default.w2p  clouds and lightnings

fx\characters\djin\djin_prepare_attack.w2p   decreasing sphere

fx\characters\djin\djin_aard_reaction.w2p dome electro/aard

*/